package com.hero.ui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

import com.hero.HeroDesigner;
import com.hero.ui.widgets.LevelTF;
import com.hero.util.Rounder;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class BasicConfigurationPanel extends JPanel {
	private static final long serialVersionUID = 7064881773947894895L;

	private JLabel basePointsLbl;

	LevelTF basePointsTF;

	private JLabel disadPointsAllowedLbl;

	LevelTF disadPointsAllowedTF;

	private JLabel disadPointsUsedLbl;

	private JLabel disadPointsUsedValueLbl;

	private JLabel experienceEarnedLbl;

	LevelTF experienceEarnedTF;

	private JLabel experienceSpentLbl;

	private JLabel experienceSpentValueLbl;

	private JLabel totalPointsLbl;

	private JLabel totalPointsValueLbl;

	private JLabel unspentExperienceLbl;

	private JLabel unspentExperienceValueLbl;

	public BasicConfigurationPanel() {
		super(new GridBagLayout());
		initWidgets();
		initListeners();
		layoutComponent();
	}

	private void initListeners() {
		experienceEarnedTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						HeroDesigner.getActiveHero().setExperience(
								experienceEarnedTF.getCurrent());
						setValues();
					}
				});
		basePointsTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						HeroDesigner.getActiveHero().setBasePoints(
								basePointsTF.getCurrent());
						setValues();
					}
				});
		disadPointsAllowedTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						HeroDesigner.getActiveHero().setDisadPoints(
								disadPointsAllowedTF.getCurrent());
						setValues();
					}
				});
	}

	private void initWidgets() {
		experienceEarnedLbl = new JLabel("Experience Earned:");
		experienceSpentLbl = new JLabel("Experience Spent:");
		unspentExperienceLbl = new JLabel("Unspent Experience:");
		basePointsLbl = new JLabel("Base Points:");
		boolean is6E = HeroDesigner.getActiveTemplate().is6E();
		if (is6E) {
			basePointsLbl.setText("Points:");
		}
		String disad = "Max. Disad.Points";
		if (is6E) disad = "Matching Complications";
		disadPointsAllowedLbl = new JLabel(disad);
		totalPointsLbl = new JLabel("Total Points Spent");
		totalPointsValueLbl = new JLabel("");

		experienceEarnedTF = new LevelTF(HeroDesigner.getActiveHero()
				.getExperience(), 9999, 0);
		experienceSpentValueLbl = new JLabel("");
		unspentExperienceValueLbl = new JLabel("");
		disad = "Disad. Points Used:";
		if (is6E) disad = "Complication Points Used:";
		disadPointsUsedLbl = new JLabel(disad);
		disadPointsUsedValueLbl = new JLabel("");
		basePointsTF = new LevelTF(
				HeroDesigner.getActiveHero().getBasePoints(), 9999, -9999);
		disadPointsAllowedTF = new LevelTF(HeroDesigner.getActiveHero()
				.getDisadPoints(), 9999, 0);
		setValues();
	}

	private void layoutComponent() {
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 0;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.fill = GridBagConstraints.NONE;
		gbc.insets = new Insets(5, 5, 5, 5);
		add(basePointsLbl, gbc);
		gbc.gridy++;
		add(disadPointsAllowedLbl, gbc);
		gbc.gridy++;
		add(disadPointsUsedLbl, gbc);
		gbc.gridy++;
		add(experienceEarnedLbl, gbc);
		gbc.gridy++;
		add(experienceSpentLbl, gbc);
		gbc.gridy++;
		add(unspentExperienceLbl, gbc);
		gbc.gridy = 0;
		gbc.gridx = 1;
		gbc.weightx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		add(basePointsTF, gbc);
		gbc.gridy++;
		add(disadPointsAllowedTF, gbc);
		gbc.gridy++;
		add(disadPointsUsedValueLbl, gbc);
		gbc.gridy++;
		add(experienceEarnedTF, gbc);
		gbc.gridy++;
		add(experienceSpentValueLbl, gbc);
		gbc.gridy++;
		add(unspentExperienceValueLbl, gbc);
		gbc.gridy++;
		gbc.weighty = 1;
		gbc.anchor = GridBagConstraints.NORTHWEST;
		add(totalPointsValueLbl, gbc);
		gbc.gridx = 0;
		gbc.anchor = GridBagConstraints.NORTHEAST;
		add(totalPointsLbl, gbc);

		setBorder(BorderFactory.createTitledBorder("Basic Configuration"));
	}

	/**
	 * Resets this panel with the values from the currently active character.
	 */
	public void reset() {
		experienceEarnedTF.setCurrent(HeroDesigner.getActiveHero()
				.getExperience());
		basePointsTF.setCurrent(HeroDesigner.getActiveHero().getBasePoints());
		disadPointsAllowedTF.setCurrent(HeroDesigner.getActiveHero()
				.getDisadPoints());
		boolean is6E = HeroDesigner.getActiveTemplate().is6E();
		String disad = "Max. Disad. Points";
		if (is6E) disad = "Matching Complications";
		disadPointsAllowedLbl.setText(disad);
		disad = "Disad. Points Used:";
		if (is6E) {
			disad = "Complication Points Used:";
		}
		disadPointsUsedLbl.setText(disad);
		if (is6E) {
			basePointsLbl.setText("Points:");
		} else {
			basePointsLbl.setText("Base Points:");
		}
		setValues();
	}

	void setValues() {
		int experience = HeroDesigner.getActiveHero().getExperience();
		int base = HeroDesigner.getActiveHero().getBasePoints();
		int disad = HeroDesigner.getActiveHero().getDisadPoints();
		int totalSpent = (int) Rounder.roundUp(HeroDesigner.getActiveHero()
				.getSpentTotal());
		int disadsUsed = HeroDesigner.getActiveHero().getDisadsUsed();
		int expSpent = totalSpent - (base + disadsUsed);
		if (HeroDesigner.getActiveTemplate().is6E()) {
			expSpent += disadsUsed;
		}
		if (expSpent < 0) {
			expSpent = 0;
		}
		int unspent = experience - expSpent;
		if (unspent < 0) {
			unspent = 0;
		}
		experienceSpentValueLbl.setText("" + expSpent);
		unspentExperienceValueLbl.setText("" + unspent);
		if (experience - expSpent < 0) {
			experienceSpentValueLbl.setForeground(Color.red);
		} else {
			experienceSpentValueLbl.setForeground(Color.black);
		}
		disadPointsUsedValueLbl.setText("" + disadsUsed);
		if (disadsUsed > disad) {
			disadPointsUsedValueLbl.setForeground(Color.red);
		} else {
			disadPointsUsedValueLbl.setForeground(Color.black);
		}
		totalPointsValueLbl.setText("" + totalSpent);
		if (expSpent > experience) {
			totalPointsValueLbl.setForeground(Color.red);
		} else {
			totalPointsValueLbl.setForeground(Color.black);
		}
	}

	/**
	 * Updates the various point totals.
	 */
	public void updateTotal() {
		setValues();
	}
}